#!/usr/bin/sh
eval 'if [ -x /usr/local/cpanel/3rdparty/bin/perl ]; then exec /usr/local/cpanel/3rdparty/bin/perl -x -- $0 ${1+"$@"}; else exec /usr/bin/perl -x $0 ${1+"$@"}; fi;'
if 0;

#!/usr/bin/perl

# Copyright (c) Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

BEGIN { unshift @INC, '/usr/local/cpanel', '/scripts'; }

use strict;

use Cpanel::Config::userdata::Load  ();
use Cpanel::Config::userdata::Cache ();
use Cpanel::Logger                  ();
use Cpanel::PwCache                 ();
use Carp                            ();

my ( $SubDomains, $MULTIPARKED, %DOCROOTS, %domainCache );

my $PERMIT_MEMORY_CACHE = 1;

sub getmultiparked_my {
    my $user = $_[0];
    if ( !$MULTIPARKED ) {
        $MULTIPARKED = {};
        my $cache = Cpanel::Config::userdata::Cache::load_cache( $user, $PERMIT_MEMORY_CACHE );

        # $cache is a HASHREF
        # $cache keys are domains
        # $cache values are a ARRAYREF with ( 0 $owner, 1 $reseller, 2 $type, 3 $parent, 4 $docroot )
        if ( $cache && %$cache ) {
            for my $domain ( grep { $cache->{$_}->[2] eq 'parked' || $cache->{$_}->[2] eq 'addon' } keys %$cache ) {
                $MULTIPARKED->{ $cache->{$domain}->[3] }->{$domain} = $cache->{$domain}->[4];
            }
        }
    }
    return %$MULTIPARKED;
}


sub getdocroot_my {
    my $domain = $_[0];
    my $user = $_[1];
    my $docroot;

    my $ud = Cpanel::Config::userdata::Load::load_userdata( $user, $domain );
    if ( $ud && keys %$ud ) {
        $docroot = $ud->{'documentroot'};
    }
    else {
        if ( !$MULTIPARKED ) {
            getmultiparked_my();
        }
        for my $sub_domain ( keys %$MULTIPARKED ) {
            if ( exists $MULTIPARKED->{$sub_domain}->{$domain} ) {
                $docroot = $MULTIPARKED->{$sub_domain}->{$domain};
                last;
            }
        }
    }

    if ( !$docroot ) {
        $docroot = $Cpanel::homedir . '/public_html';
    }
    if (wantarray) {
        ( my $reldocroot = $docroot ) =~ s{^$Cpanel::homedir/}{};
        return ( $docroot, $reldocroot );
    }
    return $docroot;
}


my $num_args = $#ARGV + 1;
if ($num_args != 2) {
  print "";
  exit;
}

my $name = $ARGV[0];
my $dm = $ARGV[1];
my $path = getdocroot_my($dm, $name);
if ($path eq "/public_html") {
print "";
} else {
print $path;
}

