<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Clients_Block extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_clients_block';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Clients Block', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-user-circle-o';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'general_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'heading1',
            [
                'label'     => esc_html__( 'Heading Line-1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading2',
            [
                'label'     => esc_html__( 'Heading Line-2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
			'img_seven_elementor_id',
			[
				'label' => esc_html__( 'Left Side Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'img_one_elementor_id',
			[
				'label' => esc_html__( 'Client Image - 1', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'img_two_elementor_id',
			[
				'label' => esc_html__( 'Client Image - 2', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'img_three_elementor_id',
			[
				'label' => esc_html__( 'Client Image - 3', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'img_four_elementor_id',
			[
				'label' => esc_html__( 'Client Image - 4', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'img_five_elementor_id',
			[
				'label' => esc_html__( 'Client Image - 5', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'img_six_elementor_id',
			[
				'label' => esc_html__( 'Client Image - 6', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
            'pt_bg',
            [
                'label'     => esc_html__('Implement Dark Pattern Background', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

		$args['heading1'] =  $settings['heading1'];
		$args['heading2'] =  $settings['heading2'];
		$args['img_one_elementor_id'] =  $settings['img_one_elementor_id'];
		$args['img_two_elementor_id'] =  $settings['img_two_elementor_id'];
		$args['img_three_elementor_id'] =  $settings['img_three_elementor_id'];
		$args['img_four_elementor_id'] =  $settings['img_four_elementor_id'];
		$args['img_five_elementor_id'] =  $settings['img_five_elementor_id'];
		$args['img_six_elementor_id'] =  $settings['img_six_elementor_id'];
		$args['img_seven_elementor_id'] =  $settings['img_seven_elementor_id'];
		$args['pt_bg'] =  $settings['pt_bg'];
		
        if( function_exists( 'maxhost_clients_block_one_shortcode' ) ) {
            echo maxhost_clients_block_one_shortcode( $args );
        }

    }

}