<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Domain_Package extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_domain_package';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Domain Package Box', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-price-list';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id',
			[
				'label' => esc_html__( 'Upload Top Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__('Image Size should be 75x30.', 'maxhost'),
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
            'text',
            [
                'label'     => esc_html__( 'Text Below Image', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'price',
            [
                'label'     => esc_html__( 'Price with Currency', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_label',
            [
                'label'     => esc_html__( 'Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_url',
            [
                'label'     => esc_html__( 'Button URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['img_one_elementor_id'] =  $settings['img_one_elementor_id'];
		$args['text'] =  $settings['text'];
		$args['price'] =  $settings['price'];
		$args['button_label'] =  $settings['button_label'];
		$args['button_url'] =  $settings['button_url'];
       
        if( function_exists( 'maxhost_domains_package_box_shortcode' ) ) {
            echo maxhost_domains_package_box_shortcode( $args );
        }

    }

}