<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Features_Block_01 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_features_block_01';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Features Block 01', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-table-of-contents';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'General', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'maxhost_shortcodes_parallax_bg',
            [
                'label'     => esc_html__("Section Background Image URL", 'maxhost'),
                'type' => \Elementor\Controls_Manager::TEXT,
                "description" => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'crossed_top',
            [
                'label'     => esc_html__( 'Crossed Shaped Section Top', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->add_control(
            'crossed_bottom',
            [
                'label'     => esc_html__( 'Crossed Shaped Section Bottom', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'left_content_section',
            [
                'label'     => esc_html__( 'Left Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
            'left_heading1',
            [
                'label'     => esc_html__( 'Left Heading Line-1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'left_heading2',
            [
                'label'     => esc_html__( 'Left Heading Line-2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id',
			[
				'label' => esc_html__( 'Left Side Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
            'features_one',
            [
                'label'     => esc_html__( 'Left Side Bullet Points', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'right_content_section',
            [
                'label'     => esc_html__( 'Right Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'right_heading1',
            [
                'label'     => esc_html__( 'Right Heading Line-1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'right_heading2',
            [
                'label'     => esc_html__( 'Right Heading Line-2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain_name1',
            [
                'label'     => esc_html__( '1st Domain Name', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_label1',
            [
                'label'     => esc_html__( '1st Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_url1',
            [
                'label'     => esc_html__( '1st Button URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain_name2',
            [
                'label'     => esc_html__( '2nd Domain Name', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_label2',
            [
                'label'     => esc_html__( '2nd Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_url2',
            [
                'label'     => esc_html__( '2nd Button URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain_name3',
            [
                'label'     => esc_html__( '3rd Domain Name', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_label3',
            [
                'label'     => esc_html__( '3rd Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_url3',
            [
                'label'     => esc_html__( '3rd Button URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain_name4',
            [
                'label'     => esc_html__( '4th Domain Name', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_label4',
            [
                'label'     => esc_html__( '4th Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_url4',
            [
                'label'     => esc_html__( '4th Button URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain_name5',
            [
                'label'     => esc_html__( '5th Domain Name', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_label5',
            [
                'label'     => esc_html__( '5th Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_url5',
            [
                'label'     => esc_html__( '5th Button URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

		$args['maxhost_shortcodes_parallax_bg'] =  $settings['maxhost_shortcodes_parallax_bg'];
		$args['left_heading1'] =  $settings['left_heading1'];
		$args['left_heading2'] =  $settings['left_heading2'];
		$args['img_one_elementor_id'] =  $settings['img_one_elementor_id'];
		$args['right_heading1'] =  $settings['right_heading1'];
		$args['right_heading2'] =  $settings['right_heading2'];		
		$args['crossed_top'] =  $settings['crossed_top'];
		$args['crossed_bottom'] =  $settings['crossed_bottom'];
		$args['features_one'] =  $settings['features_one'];
		$args['domain_name1'] =  $settings['domain_name1'];
		$args['button_label1'] =  $settings['button_label1'];
		$args['button_url1'] =  $settings['button_url1'];
		$args['domain_name2'] =  $settings['domain_name2'];
		$args['button_label2'] =  $settings['button_label2'];
		$args['button_url2'] =  $settings['button_url2'];
		$args['domain_name3'] =  $settings['domain_name3'];
		$args['button_label3'] =  $settings['button_label3'];
		$args['button_url3'] =  $settings['button_url3'];
		$args['domain_name4'] =  $settings['domain_name4'];
		$args['button_label4'] =  $settings['button_label4'];
		$args['button_url4'] =  $settings['button_url4'];
		$args['domain_name5'] =  $settings['domain_name5'];
		$args['button_label5'] =  $settings['button_label5'];
		$args['button_url5'] =  $settings['button_url5'];
       
        if( function_exists( 'maxhost_features_block_one_shortcode' ) ) {
            echo maxhost_features_block_one_shortcode( $args );
        }

    }

}