<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Iconic_Features_02 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_iconic_features_02';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Features with Icons 02', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-favorite';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'icon',
            [
                'label'     => esc_html__("Icon", 'maxhost'),
                'type' => \Elementor\Controls_Manager::TEXT,
                "description" => esc_html__('Icon list - ', 'maxhost').'<a href="https://simplelineicons.github.io/" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'fawesome',
            [
                'label'     => esc_html__( 'Use Font-Awesome Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => esc_html__("Use Font-Awesome Icons instead Simple Line Icons. Maxhost supports Font-Awesome up to version 4.7 Icons.", 'maxhost'),
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->add_control(
            'title',
            [
                'label'     => esc_html__( 'Feature Title', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text',
            [
                'label'     => esc_html__( 'Text Below Title', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'font_color',
            [
                'label'     => esc_html__('Font Color', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '' => esc_html__('Choose Color', 'maxhost'),
                    '' => esc_html__('Black', 'maxhost'),
					'font-white' => esc_html__('White', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'active',
            [
                'label'     => esc_html__( 'Want to make this feature highlighted?', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

		$args['icon'] =  $settings['icon'];
		$args['fawesome'] =  $settings['fawesome'];
		$args['title'] =  $settings['title'];
		$args['text'] =  $settings['text'];
		$args['font_color'] =  $settings['font_color'];
		$args['active'] =  $settings['active'];
       
        if( function_exists( 'maxhost_iconic_features_two_shortcode' ) ) {
            echo maxhost_iconic_features_two_shortcode( $args );
        }

    }

}