<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Testimoni_02 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_testimoni_02';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Testimonial - 02', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'fa fa-users';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'maxhost_shortcodes_parallax_bg',
            [
                'label'     => esc_html__( 'Section Parallax Background Image URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'section_heading',
            [
                'label'     => esc_html__( 'Section Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'section_heading2',
            [
                'label'     => esc_html__( 'Section Sub-Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'number_of_tabs',
            [
                'label'     => esc_html__('Number of Reviews to Show', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '1' => esc_html__('1', 'maxhost'),
                    '2' => esc_html__('2', 'maxhost'),
                    '3' => esc_html__('3', 'maxhost'),
                    '4' => esc_html__('4', 'maxhost'),
                    '5' => esc_html__('5', 'maxhost'),
                    '6' => esc_html__('6', 'maxhost'),
					'7' => esc_html__('7', 'maxhost'),
                    '8' => esc_html__('8', 'maxhost'),
                    '9' => esc_html__('9', 'maxhost'),
                    '10' => esc_html__('10', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();

        //Filters
        $this->start_controls_section(
            'clients_section',
            [
                'label'     => esc_html__( 'Clients', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'client_name0',
            [
                'label'     => esc_html__( 'Name of Client - 1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'company_name0',
            [
                'label'     => esc_html__( 'Company of Client - 1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text0',
            [
                'label'     => esc_html__( 'What Client - 1 Says', 'maxhost' ),              
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'client_name1',
            [
                'label'     => esc_html__( 'Name of Client - 2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'company_name1',
            [
                'label'     => esc_html__( 'Company of Client - 2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text1',
            [
                'label'     => esc_html__( 'What Client - 2 Says', 'maxhost' ),              
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'client_name2',
            [
                'label'     => esc_html__( 'Name of Client - 3', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'company_name2',
            [
                'label'     => esc_html__( 'Company of Client - 3', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text2',
            [
                'label'     => esc_html__( 'What Client - 3 Says', 'maxhost' ),              
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'client_name3',
            [
                'label'     => esc_html__( 'Name of Client - 4', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'company_name3',
            [
                'label'     => esc_html__( 'Company of Client - 4', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text3',
            [
                'label'     => esc_html__( 'What Client - 4 Says', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'client_name4',
            [
                'label'     => esc_html__( 'Name of Client - 5', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'company_name4',
            [
                'label'     => esc_html__( 'Company of Client - 5', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text4',
            [
                'label'     => esc_html__( 'What Client - 5 Says', 'maxhost' ),              
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'client_name5',
            [
                'label'     => esc_html__( 'Name of Client - 6', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'company_name5',
            [
                'label'     => esc_html__( 'Company of Client - 6', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text5',
            [
                'label'     => esc_html__( 'What Client - 6 Says', 'maxhost' ),              
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'client_name6',
            [
                'label'     => esc_html__( 'Name of Client - 7', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'company_name6',
            [
                'label'     => esc_html__( 'Company of Client - 7', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text6',
            [
                'label'     => esc_html__( 'What Client - 7 Says', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'client_name7',
            [
                'label'     => esc_html__( 'Name of Client - 8', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'company_name7',
            [
                'label'     => esc_html__( 'Company of Client - 8', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text7',
            [
                'label'     => esc_html__( 'What Client - 8 Says', 'maxhost' ),              
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'client_name8',
            [
                'label'     => esc_html__( 'Name of Client - 9', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'company_name8',
            [
                'label'     => esc_html__( 'Company of Client - 9', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text8',
            [
                'label'     => esc_html__( 'What Client - 9 Says', 'maxhost' ),              
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'client_name9',
            [
                'label'     => esc_html__( 'Name of Client - 10', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'company_name9',
            [
                'label'     => esc_html__( 'Company of Client - 10', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'text9',
            [
                'label'     => esc_html__( 'What Client - 10 Says', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['number_of_tabs'] =  $settings['number_of_tabs'];
		$args['maxhost_shortcodes_parallax_bg'] =  $settings['maxhost_shortcodes_parallax_bg'];
		$args['section_heading'] =  $settings['section_heading'];
		$args['section_heading2'] =  $settings['section_heading2'];
		
		$args['client_name0'] =  $settings['client_name0'];
		$args['client_name1'] =  $settings['client_name1'];
		$args['client_name2'] =  $settings['client_name2'];
		$args['client_name3'] =  $settings['client_name3'];
		$args['client_name4'] =  $settings['client_name4'];
		$args['client_name5'] =  $settings['client_name5'];
		$args['client_name6'] =  $settings['client_name6'];
		$args['client_name7'] =  $settings['client_name7'];
		$args['client_name8'] =  $settings['client_name8'];
		$args['client_name9'] =  $settings['client_name9'];
		
		$args['company_name0'] =  $settings['company_name0'];
		$args['company_name1'] =  $settings['company_name1'];
		$args['company_name2'] =  $settings['company_name2'];
		$args['company_name3'] =  $settings['company_name3'];
		$args['company_name4'] =  $settings['company_name4'];
		$args['company_name5'] =  $settings['company_name5'];
		$args['company_name6'] =  $settings['company_name6'];
		$args['company_name7'] =  $settings['company_name7'];
		$args['company_name8'] =  $settings['company_name8'];
		$args['company_name9'] =  $settings['company_name9'];
		
		$args['text0'] =  $settings['text0'];
		$args['text1'] =  $settings['text1'];
		$args['text2'] =  $settings['text2'];
		$args['text3'] =  $settings['text3'];
		$args['text4'] =  $settings['text4'];
		$args['text5'] =  $settings['text5'];
		$args['text6'] =  $settings['text6'];
		$args['text7'] =  $settings['text7'];
		$args['text8'] =  $settings['text8'];
		$args['text9'] =  $settings['text9'];
       
        if( function_exists( 'maxhost_testimonial_two_shortcode' ) ) {
            echo maxhost_testimonial_two_shortcode( $args );
        }

    }

}