<?php
/**
 * Creates Footer Post Type
 * ................................................................
 */

// Initialize
//................................................................
StaticFooterContent::onload();

// Easy access to static block output
//................................................................
function the_footer_static_block( $id = false, $args = array() ) {
	if ($id) {
		$args["id"] = $id;
		echo StaticFooterContent::get_static_content($args);
	}
}

#-----------------------------------------------------------------
# Static Block Class
#-----------------------------------------------------------------
class StaticFooterContent {
	static function onload() {
		add_action('init', array(__CLASS__,'init_static_blocks'));
		//add_action("after_switch_theme", "flush_rewrite_rules", 10 ,  2); // update permalinks for new rewrite rules
		//add_shortcode('static_content', array(__CLASS__,'static_content_shortcode'));
		add_shortcode('maxhost_ftr_builder', array(__CLASS__,'static_content_shortcode'));
	}
	static function init_static_blocks() {
		if (function_exists('register_post_type')) {
			register_post_type('maxhost_ftr_builder',
				array(
					'labels' => array(
							'name' =>				esc_html_x('Footer Builder', 'post type general name', 'maxhost'),
							'singular_name' =>		esc_html_x('Footer Builder', 'post type singular name', 'maxhost'),
							'add_new' =>			esc_html_x('Add New', 'block', 'maxhost'),
							'add_new_item' =>		esc_html__('Add New Footer', 'maxhost'),
							'edit_item' =>			esc_html__('Edit Footer', 'maxhost'),
							'new_item' =>			esc_html__('New Footer', 'maxhost'),
							'all_items' =>			esc_html__('Footers', 'maxhost'),
							'view_item' =>			esc_html__('View Footer', 'maxhost'),
							'search_items' =>		esc_html__('Search', 'maxhost'),
							'not_found' =>			esc_html__('No Footers found', 'maxhost'),
							'not_found_in_trash' =>	esc_html__('No Footers found in Trash', 'maxhost'), 
							'parent_item_colon' => '',
							'menu_name' => 'Footer Builder'
						),
					'exclude_from_search' => true,
					'publicly_queryable'  => true,
					'public'              => true,
					'show_ui'             => true,
					'show_in_menu'		  => false,
					'show_in_admin_bar'	  => true,
					'query_var'           => 'maxhost_ftr_builder',
					'rewrite'             => array('slug' => 'maxhost_ftr_builder'),
					'supports'            => array(
						'title',
						'editor',
						'revisions',
					),
				)
			);
		}
	}
}