#!/usr/bin/bash

# RPM preun script
# Note: Also called from Debian cloudlinux-linksafe.prerm scriptlet
# Arguments:
# RPM
# "$1" == 0 -- RPM will uninstall package
# "$1" == 1 -- RPM upgrade/downgrade package
# DEB
# "$1" == "remove" - DEB will uninstall package
# "$1" == "upgrade" -- DEB
# Common
# $2 - solo_marker - /etc/cloudlinux-edition-solo

# "cloudlinux-linksafe PRE UNINSTALL STARTED"

# RPM/DEB argument unified interpreter
argument=''
if [[ "$1" == 0 || "$1" == "remove" ]]; then
	# "$1" == 0 -- RPM will uninstall package
	# "$1" == "remove" - DEB will uninstall package
	argument='uninstall'
elif [[ "$1" == 1 || "$1" == "upgrade" ]]; then
	# "$1" == 1 -- RPM upgrade/downgrade package
	# "$1" == "upgrade" -- DEB
	argument='upgrade'
else
	# Unknown argument
	exit 0
fi

SOLO_MARKER="$2"
CONTAINER_MARKER="$3"

if [ -f "$SOLO_MARKER" ] || [ -f "$CONTAINER_MARKER" ]; then
    exit 0
fi
if [[ "$argument" == 'uninstall' ]]; then
    /usr/share/cloudlinux-linksafe/cpanel/hooks/cpanel-linksafe-delete-hooks
fi

# "cloudlinux-linksafe PRE UNINSTALL FINISHED"
