<?php
/**
 * Cacheable interface
 * Implemented by Cache classes
 *
 * @package notification
 */

namespace BracketSpace\Notification\Utils\Interfaces;

/**
 * Cacheable interface
 */
interface Cacheable {

	/**
	 * Sets cache value
	 *
	 * @param mixed $value value to store.
	 */
	public function set( $value ): Cacheable;

	/**
	 * Adds cache if it's not already set
	 *
	 * @param mixed $value value to store.
	 */
	public function add( $value ): Cacheable;

	/**
	 * Gets value from cache
	 *
	 * @param  boolean $force true if cache will be forced to get from storage.
	 * @return mixed          cached value
	 */
	public function get( $force );

	/**
	 * Deletes value from cache
	 */
	public function delete(): Cacheable;

}
