<?php 
if (isset($_GET['import-demo']) && $_GET['import-demo'] == true) {

   // Function to install and activate plugins
    function pharmacy_shop_import_demo_content() {

        // Display the preloader only for plugin installation
        echo '<div id="plugin-loader" style="display: flex; align-items: center; justify-content: center; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255, 255, 255, 0.8); z-index: 9999;">
                <img src="' . esc_url(get_template_directory_uri()) . '/assets/images/loader.png" alt="Loading..." width="60" height="60" />
              </div>';

        // Define the plugins you want to install and activate
        $plugins = array(
            array(
                'slug' => 'woocommerce',
                'file' => 'woocommerce/woocommerce.php',
                'url'  => 'https://downloads.wordpress.org/plugin/woocommerce.latest-stable.zip'
            ),
            array(
                'slug' => 'yith-woocommerce-wishlist',
                'file' => 'yith-woocommerce-wishlist/init.php',
                'url'  => 'https://downloads.wordpress.org/plugin/yith-woocommerce-wishlist.latest-stable.zip'
            ),
            array(
                'slug' => 'currency-switcher-woocommerce',
                'file' => 'currency-switcher-woocommerce/currency-switcher-woocommerce.php',
                'url'  => 'https://downloads.wordpress.org/plugin/currency-switcher-woocommerce.latest-stable.zip'
            ),
            array(
                'slug' => 'gtranslate',
                'file' => 'gtranslate/gtranslate.php',
                'url'  => 'https://downloads.wordpress.org/plugin/gtranslate.latest-stable.zip' // Correct GTranslate URL
            ),
            array(
                'slug' => 'advanced-appointment-booking-scheduling',
                'file' => 'advanced-appointment-booking-scheduling/advanced-appointment-booking.php',
                'url'  => 'https://downloads.wordpress.org/plugin/advanced-appointment-booking-scheduling.zip'
            ),
        );

        // Include required files for plugin installation
        if (!function_exists('plugins_api')) {
            include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
        }
        if (!function_exists('activate_plugin')) {
            include_once(ABSPATH . 'wp-admin/includes/plugin.php');
        }
        include_once(ABSPATH . 'wp-admin/includes/file.php');
        include_once(ABSPATH . 'wp-admin/includes/misc.php');
        include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

        // Loop through each plugin
        foreach ($plugins as $plugin) {
            $plugin_file = WP_PLUGIN_DIR . '/' . $plugin['file'];

            // Check if the plugin is installed
            if (!file_exists($plugin_file)) {
                // If the plugin is not installed, download and install it
                $upgrader = new Plugin_Upgrader();
                $result = $upgrader->install($plugin['url']);

                // Check for installation errors
                if (is_wp_error($result)) {
                    error_log('Plugin installation failed: ' . $plugin['slug'] . ' - ' . $result->get_error_message());
                    continue;
                }
            }

            // If the plugin folder exists but the plugin is not active, activate it
            if (file_exists($plugin_file) && !is_plugin_active($plugin['file'])) {
                $result = activate_plugin($plugin['file']);

                // Check for activation errors
                if (is_wp_error($result)) {
                    error_log('Plugin activation failed: ' . $plugin['slug'] . ' - ' . $result->get_error_message());
                }
            }
        }

        // Hide the preloader after the process is complete
        echo '<script type="text/javascript">
                document.getElementById("plugin-loader").style.display = "none";
              </script>';

        // Add filter to skip WooCommerce setup wizard after activation
        add_filter('woocommerce_prevent_automatic_wizard_redirect', '__return_true');
    }

    // Call the import function
    pharmacy_shop_import_demo_content();
    
    // ------- Create Nav Menu --------
$pharmacy_shop_menuname = 'Main Menus';
$pharmacy_shop_bpmenulocation = 'primary-menu';
$pharmacy_shop_menu_exists = wp_get_nav_menu_object($pharmacy_shop_menuname);

if (!$pharmacy_shop_menu_exists) {
    $pharmacy_shop_menu_id = wp_create_nav_menu($pharmacy_shop_menuname);

    // Create Home Page
    $pharmacy_shop_home_title = 'Home';
    $pharmacy_shop_home = array(
        'post_type' => 'page',
        'post_title' => $pharmacy_shop_home_title,
        'post_content' => '',
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'home'
    );
    $pharmacy_shop_home_id = wp_insert_post($pharmacy_shop_home);

    // Assign Home Page Template
    add_post_meta($pharmacy_shop_home_id, '_wp_page_template', 'page-template/front-page.php');

    // Update options to set Home Page as the front page
    update_option('page_on_front', $pharmacy_shop_home_id);
    update_option('show_on_front', 'page');

    // Add Home Page to Menu
    wp_update_nav_menu_item($pharmacy_shop_menu_id, 0, array(
        'menu-item-title' => __('Home', 'pharmacy-shop'),
        'menu-item-classes' => 'home',
        'menu-item-url' => home_url('/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $pharmacy_shop_home_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create About Us Page with Dummy Content
    $pharmacy_shop_about_title = 'About Us';
    $pharmacy_shop_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $pharmacy_shop_about = array(
        'post_type' => 'page',
        'post_title' => $pharmacy_shop_about_title,
        'post_content' => $pharmacy_shop_about_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'about-us'
    );
    $pharmacy_shop_about_id = wp_insert_post($pharmacy_shop_about);

    // Add About Us Page to Menu
    wp_update_nav_menu_item($pharmacy_shop_menu_id, 0, array(
        'menu-item-title' => __('About Us', 'pharmacy-shop'),
        'menu-item-classes' => 'about-us',
        'menu-item-url' => home_url('/about-us/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $pharmacy_shop_about_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Services Page with Dummy Content
    $pharmacy_shop_services_title = 'Services';
    $pharmacy_shop_services_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $pharmacy_shop_services = array(
        'post_type' => 'page',
        'post_title' => $pharmacy_shop_services_title,
        'post_content' => $pharmacy_shop_services_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'services'
    );
    $pharmacy_shop_services_id = wp_insert_post($pharmacy_shop_services);

    // Add Services Page to Menu
    wp_update_nav_menu_item($pharmacy_shop_menu_id, 0, array(
        'menu-item-title' => __('Services', 'pharmacy-shop'),
        'menu-item-classes' => 'services',
        'menu-item-url' => home_url('/services/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $pharmacy_shop_services_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Pages Page with Dummy Content
    $pharmacy_shop_pages_title = 'Pages';
    $pharmacy_shop_pages_content = '<h2>Our Pages</h2>
    <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>';
    $pharmacy_shop_pages = array(
        'post_type' => 'page',
        'post_title' => $pharmacy_shop_pages_title,
        'post_content' => $pharmacy_shop_pages_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'pages'
    );
    $pharmacy_shop_pages_id = wp_insert_post($pharmacy_shop_pages);

    // Add Pages Page to Menu
    wp_update_nav_menu_item($pharmacy_shop_menu_id, 0, array(
        'menu-item-title' => __('Pages', 'pharmacy-shop'),
        'menu-item-classes' => 'pages',
        'menu-item-url' => home_url('/pages/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $pharmacy_shop_pages_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Contact Page with Dummy Content
    $pharmacy_shop_contact_title = 'Contact';
    $pharmacy_shop_contact_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $pharmacy_shop_contact = array(
        'post_type' => 'page',
        'post_title' => $pharmacy_shop_contact_title,
        'post_content' => $pharmacy_shop_contact_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'contact'
    );
    $pharmacy_shop_contact_id = wp_insert_post($pharmacy_shop_contact);

    // Add Contact Page to Menu
    wp_update_nav_menu_item($pharmacy_shop_menu_id, 0, array(
        'menu-item-title' => __('Contact', 'pharmacy-shop'),
        'menu-item-classes' => 'contact',
        'menu-item-url' => home_url('/contact/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $pharmacy_shop_contact_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Set the menu location if it's not already set
    if (!has_nav_menu($pharmacy_shop_bpmenulocation)) {
        $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
        if (empty($locations)) {
            $locations = array();
        }
        $locations[$pharmacy_shop_bpmenulocation] = $pharmacy_shop_menu_id;
        set_theme_mod('nav_menu_locations', $locations);
    }
}

        //---Header--//
        set_theme_mod('pharmacy_shop_topbar_text', 'Welcome to Pharmacy. We provides best medical accessories');
        set_theme_mod('pharmacy_shop_phone', '1800 1200 110');
        set_theme_mod('pharmacy_shop_mail', 'Pharmacy@yourmail.com');
        set_theme_mod('pharmacy_shop_note_link', '#');

        set_theme_mod('pharmacy_shop_category_text', 'Select Category');
        set_theme_mod('pharmacy_shop_product_category_number', true);

        // Slider Section
        set_theme_mod('pharmacy_shop_slider_arrows', true);
        set_theme_mod('pharmacy_shop_slider_short_heading', 'Save Up To 40% OFF');

        for ($i = 1; $i <= 4; $i++) {
            $pharmacy_shop_title = 'Best Medicine For';
            $pharmacy_shop_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.';

            // Create post object
            $my_post = array(
                'post_title'    => wp_strip_all_tags($pharmacy_shop_title),
                'post_status'   => 'publish',
                'post_content'  => $pharmacy_shop_content,
                'post_type'     => 'page',
            );

            // Insert the post into the database
            $post_id = wp_insert_post($my_post);

            if ($post_id) {
                // Set the theme mod for the slider page
                set_theme_mod('pharmacy_shop_slider_page' . $i, $post_id);

                $image_url = get_template_directory_uri() . '/assets/images/slider-img.png';
                $image_id = media_sideload_image($image_url, $post_id, null, 'id');

                if (!is_wp_error($image_id)) {
                    // Set the downloaded image as the post's featured image
                    set_post_thumbnail($post_id, $image_id);
                }
            }
        }

        // Create demo page for slider
        $pharmacy_shop_post_title1   = 'Special Sale';
        $pharmacy_shop_post_content1 = 'From: $20';

        $my_post1 = array(
            'post_title'   => wp_strip_all_tags($pharmacy_shop_post_title1),
            'post_content' => $pharmacy_shop_post_content1,
            'post_status'  => 'publish',
            'post_type'    => 'page', // Use 'page' to match dropdown-pages control
        );

        $post_id1 = wp_insert_post($my_post1);

        if (!is_wp_error($post_id1)) {

            // Set the theme mod with the page ID
            set_theme_mod('pharmacy_shop_static_blog_2', $post_id1);

            // Get the image path from theme directory
            $image_url1 = get_template_directory() . '/assets/images/post-img.png'; // Local file path
            $image_filetype = wp_check_filetype(basename($image_url1), null);

            // Upload the image as an attachment
            $attachment = array(
                'post_mime_type' => $image_filetype['type'],
                'post_title'     => sanitize_file_name(basename($image_url1)),
                'post_content'   => '',
                'post_status'    => 'inherit'
            );

            // Copy image to uploads directory
            $upload_dir = wp_upload_dir();
            $target_file = $upload_dir['path'] . '/' . basename($image_url1);
            copy($image_url1, $target_file);

            $attach_id = wp_insert_attachment($attachment, $target_file, $post_id1);

            // Generate attachment metadata and update
            require_once(ABSPATH . 'wp-admin/includes/image.php');
            $attach_data = wp_generate_attachment_metadata($attach_id, $target_file);
            wp_update_attachment_metadata($attach_id, $attach_data);

            // Set as featured image
            set_post_thumbnail($post_id1, $attach_id);
        }

        // products //
        set_theme_mod('pharmacy_shop_product_show_hide', true);
        set_theme_mod('pharmacy_shop_product_short_heading', 'Hot Deals');
        set_theme_mod('pharmacy_shop_product_heading', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.');

        // About Page
        $pharmacy_shop_title = 'Up To 50% Off';
        $content = 'Best Hack for Your Skin Product';

        // Create post object
        $my_post = array(
            'post_title'   => wp_strip_all_tags($pharmacy_shop_title),
            'post_content' => $content,
            'post_status'  => 'publish',
            'post_type'    => 'page',
        );

        // Insert the post into the database
        $post_id = wp_insert_post($my_post);

        if ($post_id) {
            // Set the theme mod correctly (no $i)
            set_theme_mod('pharmacy_shop_about_page', $post_id);

            // Add featured image
            $image_url = get_template_directory_uri() . '/assets/images/about-img.png';
            $image_id = media_sideload_image($image_url, $post_id, null, 'id');

            if (!is_wp_error($image_id)) {
                set_post_thumbnail($post_id, $image_id);
            }
        }

        // product section
        set_theme_mod('pharmacy_shop_recent_product_category', 'productcategory1');
        set_theme_mod('pharmacy_shop_blockbustor_deals_countdown_timer_date', '01/01/2026 05:06:59');

        // Define product category names and product titles
        $pharmacy_shop_category_names = array('productcategory1');
        $pharmacy_shop_title_array = array(
            array("Product Title Here", "Product Title Here", "Product Title Here"),
        );

        foreach ($pharmacy_shop_category_names as $pharmacy_shop_index => $pharmacy_shop_category_name) {
            // Create or retrieve the product category term ID
            $pharmacy_shop_term = term_exists($pharmacy_shop_category_name, 'product_cat');
            if ($pharmacy_shop_term === 0 || $pharmacy_shop_term === null) {
                // If the term does not exist, create it
                $pharmacy_shop_term = wp_insert_term($pharmacy_shop_category_name, 'product_cat');
            }

            if (is_wp_error($pharmacy_shop_term)) {
                error_log('Error creating category: ' . $pharmacy_shop_term->get_error_message());
                continue; // Skip to the next iteration if category creation fails
            }

            $pharmacy_shop_term_id = is_array($pharmacy_shop_term) ? $pharmacy_shop_term['term_id'] : $pharmacy_shop_term;

            // Loop to create 4 products for each category
            for ($pharmacy_shop_i = 0; $pharmacy_shop_i < 3; $pharmacy_shop_i++) {
                // Create product content
                $pharmacy_shop_title = $pharmacy_shop_title_array[$pharmacy_shop_index][$pharmacy_shop_i];

                // Create product post object
                $pharmacy_shop_my_post = array(
                    'post_title' => wp_strip_all_tags($pharmacy_shop_title),
                    'post_status' => 'publish',
                    'post_type' => 'product', // Post type set to 'product'
                );

                // Insert the product into the database
                $pharmacy_shop_post_id = wp_insert_post($pharmacy_shop_my_post);

                if (is_wp_error($pharmacy_shop_post_id)) {
                    error_log('Error creating product: ' . $pharmacy_shop_post_id->get_error_message());
                    continue; // Skip to the next product if creation fails
                }

                // Assign the category to the product
                wp_set_object_terms($pharmacy_shop_post_id, (int)$pharmacy_shop_term_id, 'product_cat');

                // Add product meta (price, etc.)
                update_post_meta($pharmacy_shop_post_id, '_regular_price', '$50.00'); // Regular price
                update_post_meta($pharmacy_shop_post_id, '_sale_price', '$45.00'); // Sale price
                update_post_meta($pharmacy_shop_post_id, '_price', '$45.00'); // Active price

                // Handle the featured image using media_sideload_image
                $pharmacy_shop_image_url = get_template_directory_uri() . '/assets/images/product-img' . ($pharmacy_shop_i + 1) . '.png';
                $pharmacy_shop_image_id = media_sideload_image($pharmacy_shop_image_url, $pharmacy_shop_post_id, null, 'id');

                if (is_wp_error($pharmacy_shop_image_id)) {
                    error_log('Error downloading image: ' . $pharmacy_shop_image_id->get_error_message());
                    continue; // Skip to the next product if image download fails
                }

                // Assign featured image to product
                set_post_thumbnail($pharmacy_shop_post_id, $pharmacy_shop_image_id);
            }
        }


    }
?>