<?php
/**
 * Displays footer widgets if assigned
 *
 * @package Pharmacy Shop
 * @subpackage pharmacy_shop
 */
?>
<?php

// Determine the number of columns dynamically for the footer (you can replace this with your logic).
$pharmacy_shop_no_of_footer_col = get_theme_mod('pharmacy_shop_footer_columns', 4); // Change this value as needed.

// Calculate the Bootstrap class for large screens (col-lg-X) for footer.
$pharmacy_shop_col_lg_footer_class = 'col-lg-' . (12 / $pharmacy_shop_no_of_footer_col);

// Calculate the Bootstrap class for medium screens (col-md-X) for footer.
$pharmacy_shop_col_md_footer_class = 'col-md-' . (12 / $pharmacy_shop_no_of_footer_col);
?>
<div class="container">
    <aside class="widget-area row py-2 pt-3" role="complementary" aria-label="<?php esc_attr_e( 'Footer', 'pharmacy-shop' ); ?>">
        <?php
        $pharmacy_shop_default_widgets = array(
            1 => 'search',
            2 => 'archives',
            3 => 'meta',
            4 => 'categories'
        );

        for ($pharmacy_shop_i = 1; $pharmacy_shop_i <= $pharmacy_shop_no_of_footer_col; $pharmacy_shop_i++) :
            $pharmacy_shop_lg_class = esc_attr($pharmacy_shop_col_lg_footer_class);
            $pharmacy_shop_md_class = esc_attr($pharmacy_shop_col_md_footer_class);
            echo '<div class="col-12 ' . $pharmacy_shop_lg_class . ' ' . $pharmacy_shop_md_class . '">';

            if (is_active_sidebar('footer-' . $pharmacy_shop_i)) {
                dynamic_sidebar('footer-' . $pharmacy_shop_i);
            } else {
                // Display default widget content if not active.
                switch ($pharmacy_shop_default_widgets[$pharmacy_shop_i] ?? '') {
                    case 'search':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Search', 'pharmacy-shop'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Search', 'pharmacy-shop'); ?></h3>
                            <?php get_search_form(); ?>
                        </aside>
                        <?php
                        break;

                    case 'archives':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Archives', 'pharmacy-shop'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Archives', 'pharmacy-shop'); ?></h3>
                            <ul><?php wp_get_archives(['type' => 'monthly']); ?></ul>
                        </aside>
                        <?php
                        break;

                    case 'meta':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Meta', 'pharmacy-shop'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Meta', 'pharmacy-shop'); ?></h3>
                            <ul>
                                <?php wp_register(); ?>
                                <li><?php wp_loginout(); ?></li>
                                <?php wp_meta(); ?>
                            </ul>
                        </aside>
                        <?php
                        break;

                    case 'categories':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Categories', 'pharmacy-shop'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Categories', 'pharmacy-shop'); ?></h3>
                            <ul><?php wp_list_categories(['title_li' => '']); ?></ul>
                        </aside>
                        <?php
                        break;
                }
            }

            echo '</div>';
        endfor;
        ?>
    </aside>
</div>